package com.xforceplus.jcnestle.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BizOrderDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务单明细id
   */
  @TableField("bizOrderDetailId")
  private String bizOrderDetailId;

  /**
   * 业务单明细号
   */
  @TableField("bizOrderDetailNo")
  private String bizOrderDetailNo;

  /**
   * 业务单号
   */
  @TableField("bizOrderNo")
  private String bizOrderNo;

  /**
   * 明细类别
   */
  @TableField("detailCategory")
  private String detailCategory;

  /**
   * 含税单价
   */
  @TableField("unitPriceWithTax")
  private BigDecimal unitPriceWithTax;

  /**
   * 单价
   */
  @TableField("unitPrice")
  private BigDecimal unitPrice;

  /**
   * 数量
   */
  private BigDecimal quantity;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * 已开票含税金额
   */
  @TableField("alreadyAmountWithTax")
  private BigDecimal alreadyAmountWithTax;

  /**
   * 已开票不含税金额
   */
  @TableField("alreadyAmountWithoutTax")
  private BigDecimal alreadyAmountWithoutTax;

  /**
   * 已开票税额
   */
  @TableField("alreadyTaxAmount")
  private BigDecimal alreadyTaxAmount;

  /**
   * 货物及服务代码
   */
  @TableField("itemCode")
  private String itemCode;

  /**
   * 货物及服务名称
   */
  @TableField("itemName")
  private String itemName;

  /**
   * 规格型号
   */
  private String specifications;

  /**
   * 数量单位
   */
  private String unit;

  /**
   * 税编简称
   */
  @TableField("itemShortName")
  private String itemShortName;

  /**
   * 价外不含税折扣
   */
  @TableField("outerDiscountWithoutTax")
  private BigDecimal outerDiscountWithoutTax;

  /**
   * 价外折扣税额
   */
  @TableField("outerDiscountTax")
  private BigDecimal outerDiscountTax;

  /**
   * 价外含税折扣
   */
  @TableField("outerDiscountWithTax")
  private BigDecimal outerDiscountWithTax;

  /**
   * 价内含税折扣
   */
  @TableField("innerDiscountWithTax")
  private BigDecimal innerDiscountWithTax;

  /**
   * 价内不含税折扣
   */
  @TableField("innerDiscountWithoutTax")
  private BigDecimal innerDiscountWithoutTax;

  /**
   * 价内折扣税额
   */
  @TableField("innerDiscountTax")
  private BigDecimal innerDiscountTax;

  /**
   * 税收分类编码
   */
  @TableField("goodsTaxNo")
  private String goodsTaxNo;

  /**
   * 税收转换代码
   */
  @TableField("taxConvertCode")
  private String taxConvertCode;

  /**
   * 是否享受税收优惠政策	否
   */
  @TableField("taxPre")
  private String taxPre;

  /**
   * 享受税收优惠政策内容
   */
  @TableField("taxPreCon")
  private String taxPreCon;

  /**
   * 零税率标志
   */
  @TableField("zeroTax")
  private String zeroTax;

  /**
   * 明细状态
   */
  private String status;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;


  /**
   * 对一关联关系 关联对象 bizOrder
   */
    private Long orderDetailRelationId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("bizOrderDetailId", bizOrderDetailId);
      map.put("bizOrderDetailNo", bizOrderDetailNo);
      map.put("bizOrderNo", bizOrderNo);
      map.put("detailCategory", detailCategory);
      map.put("unitPriceWithTax", unitPriceWithTax);
      map.put("unitPrice", unitPrice);
      map.put("quantity", quantity);
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("taxRate", taxRate);
      map.put("alreadyAmountWithTax", alreadyAmountWithTax);
      map.put("alreadyAmountWithoutTax", alreadyAmountWithoutTax);
      map.put("alreadyTaxAmount", alreadyTaxAmount);
      map.put("itemCode", itemCode);
      map.put("itemName", itemName);
      map.put("specifications", specifications);
      map.put("unit", unit);
      map.put("itemShortName", itemShortName);
      map.put("outerDiscountWithoutTax", outerDiscountWithoutTax);
      map.put("outerDiscountTax", outerDiscountTax);
      map.put("outerDiscountWithTax", outerDiscountWithTax);
      map.put("innerDiscountWithTax", innerDiscountWithTax);
      map.put("innerDiscountWithoutTax", innerDiscountWithoutTax);
      map.put("innerDiscountTax", innerDiscountTax);
      map.put("goodsTaxNo", goodsTaxNo);
      map.put("taxConvertCode", taxConvertCode);
      map.put("taxPre", taxPre);
      map.put("taxPreCon", taxPreCon);
      map.put("zeroTax", zeroTax);
      map.put("status", status);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

       map.put("orderDetailRelation.id", orderDetailRelationId);
      return map;
  }

  public static BizOrderDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BizOrderDetail entity = new BizOrderDetail();
    if(map.containsKey("bizOrderDetailId")) {
      Object obj = map.get("bizOrderDetailId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderDetailId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizOrderDetailNo")) {
      Object obj = map.get("bizOrderDetailNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderDetailNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizOrderNo")) {
      Object obj = map.get("bizOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("detailCategory")) {
      Object obj = map.get("detailCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDetailCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithTax")) {
      Object obj = map.get("unitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("alreadyAmountWithTax")) {
      Object obj = map.get("alreadyAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAlreadyAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAlreadyAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAlreadyAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAlreadyAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlreadyAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("alreadyAmountWithoutTax")) {
      Object obj = map.get("alreadyAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAlreadyAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAlreadyAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAlreadyAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAlreadyAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlreadyAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("alreadyTaxAmount")) {
      Object obj = map.get("alreadyTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAlreadyTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAlreadyTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAlreadyTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAlreadyTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlreadyTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specifications")) {
      Object obj = map.get("specifications");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecifications((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemShortName")) {
      Object obj = map.get("itemShortName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemShortName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outerDiscountWithoutTax")) {
      Object obj = map.get("outerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOuterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOuterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOuterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOuterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOuterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outerDiscountTax")) {
      Object obj = map.get("outerDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOuterDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOuterDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOuterDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOuterDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOuterDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outerDiscountWithTax")) {
      Object obj = map.get("outerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOuterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOuterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOuterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOuterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOuterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountWithTax")) {
      Object obj = map.get("innerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInnerDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountWithoutTax")) {
      Object obj = map.get("innerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInnerDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountTax")) {
      Object obj = map.get("innerDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInnerDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxConvertCode")) {
      Object obj = map.get("taxConvertCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxConvertCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPre")) {
      Object obj = map.get("taxPre");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPre((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPreCon")) {
      Object obj = map.get("taxPreCon");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPreCon((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zeroTax")) {
      Object obj = map.get("zeroTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZeroTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("orderDetailRelation.id")) {
        Object obj = map.get("orderDetailRelation.id");
      if(obj instanceof Long) {
        entity.setOrderDetailRelationId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setOrderDetailRelationId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("bizOrderDetailId")) {
      Object obj = map.get("bizOrderDetailId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderDetailId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bizOrderDetailNo")) {
      Object obj = map.get("bizOrderDetailNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderDetailNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bizOrderNo")) {
      Object obj = map.get("bizOrderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("detailCategory")) {
      Object obj = map.get("detailCategory");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDetailCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unitPriceWithTax")) {
      Object obj = map.get("unitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("alreadyAmountWithTax")) {
      Object obj = map.get("alreadyAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAlreadyAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAlreadyAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAlreadyAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAlreadyAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAlreadyAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("alreadyAmountWithoutTax")) {
      Object obj = map.get("alreadyAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAlreadyAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAlreadyAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAlreadyAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAlreadyAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAlreadyAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("alreadyTaxAmount")) {
      Object obj = map.get("alreadyTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAlreadyTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAlreadyTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAlreadyTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAlreadyTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAlreadyTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("specifications")) {
      Object obj = map.get("specifications");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecifications((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemShortName")) {
      Object obj = map.get("itemShortName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemShortName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("outerDiscountWithoutTax")) {
      Object obj = map.get("outerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOuterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOuterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOuterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOuterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOuterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outerDiscountTax")) {
      Object obj = map.get("outerDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOuterDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOuterDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOuterDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOuterDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOuterDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outerDiscountWithTax")) {
      Object obj = map.get("outerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOuterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOuterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOuterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOuterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOuterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("innerDiscountWithTax")) {
      Object obj = map.get("innerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInnerDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInnerDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInnerDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInnerDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInnerDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("innerDiscountWithoutTax")) {
      Object obj = map.get("innerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInnerDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInnerDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInnerDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInnerDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInnerDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("innerDiscountTax")) {
      Object obj = map.get("innerDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInnerDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInnerDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInnerDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInnerDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInnerDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxConvertCode")) {
      Object obj = map.get("taxConvertCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxConvertCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxPre")) {
      Object obj = map.get("taxPre");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPre((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxPreCon")) {
      Object obj = map.get("taxPreCon");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPreCon((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zeroTax")) {
      Object obj = map.get("zeroTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZeroTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("orderDetailRelation.id")) {
        Object obj = map.get("orderDetailRelation.id");
        if(obj instanceof Long) {
          this.setOrderDetailRelationId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderDetailRelationId(Long.parseLong((String)obj));
        }
      }
  }
}
