package com.xforceplus.jcnestle.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcnestle.entity.Receipt;
import com.xforceplus.jcnestle.service.IReceiptService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-13
 */
@RestController
public class ReceiptController {

  @Autowired
  private IReceiptService receiptServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param receipt ${table.comment}
   * @return
   */
  @GetMapping("/receipts" )
  public XfR getReceipts(XfPage page, Receipt receipt) {
    return XfR.ok(receiptServiceImpl.page(page, Wrappers.query(receipt)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/receipts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(receiptServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param receipt ${table.comment}
   * @return XfR
   */
  @PostMapping("/receipts")
  public XfR save(@RequestBody Receipt receipt) {
     return XfR.ok(receiptServiceImpl.save(receipt));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param receipt ${table.comment}
   * @return XfR
   */
  @PutMapping("/receipts/{id}")
  public XfR putUpdate(@RequestBody Receipt receipt,@PathVariable Long id) {
      receipt.setId(id);
      return XfR.ok(receiptServiceImpl.updateById(receipt));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param receipt ${table.comment}
   * @return XfR
   */
  @PatchMapping("/receipts/{id}")
  public XfR patchUpdate(@RequestBody Receipt receipt,@PathVariable Long id) {
      Receipt upreceipt = receiptServiceImpl.getById(id);
      if(upreceipt != null){
        upreceipt = ObjectCopyUtils.copyProperties(receipt,upreceipt,true);
      }
      return XfR.ok(receiptServiceImpl.updateById(upreceipt));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/receipts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(receiptServiceImpl.removeById(id));
  }

  @PostMapping("/receipts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "receipt");
     params.put("request", condition);

     return XfR.ok(receiptServiceImpl.querys(params));
  }

}
