package com.xforceplus.jcnestle.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcnestle.entity.Attachment;
import com.xforceplus.jcnestle.service.IAttachmentService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-06
 */
@RestController
public class AttachmentController {

  @Autowired
  private IAttachmentService attachmentServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param attachment ${table.comment}
   * @return
   */
  @GetMapping("/attachments" )
  public XfR getAttachments(XfPage page, Attachment attachment) {
    return XfR.ok(attachmentServiceImpl.page(page, Wrappers.query(attachment)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/attachments/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(attachmentServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param attachment ${table.comment}
   * @return XfR
   */
  @PostMapping("/attachments")
  public XfR save(@RequestBody Attachment attachment) {
     return XfR.ok(attachmentServiceImpl.save(attachment));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param attachment ${table.comment}
   * @return XfR
   */
  @PutMapping("/attachments/{id}")
  public XfR putUpdate(@RequestBody Attachment attachment,@PathVariable Long id) {
      attachment.setId(id);
      return XfR.ok(attachmentServiceImpl.updateById(attachment));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param attachment ${table.comment}
   * @return XfR
   */
  @PatchMapping("/attachments/{id}")
  public XfR patchUpdate(@RequestBody Attachment attachment,@PathVariable Long id) {
      Attachment upattachment = attachmentServiceImpl.getById(id);
      if(upattachment != null){
        upattachment = ObjectCopyUtils.copyProperties(attachment,upattachment,true);
      }
      return XfR.ok(attachmentServiceImpl.updateById(upattachment));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/attachments/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(attachmentServiceImpl.removeById(id));
  }

  @PostMapping("/attachments/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "attachment");
     params.put("request", condition);

     return XfR.ok(attachmentServiceImpl.querys(params));
  }

}
