package com.xforceplus.jcnestle.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcnestle.entity.DiscountReturnContact;
import com.xforceplus.jcnestle.service.IDiscountReturnContactService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-06
 */
@RestController
public class DiscountReturnContactController {

  @Autowired
  private IDiscountReturnContactService discountReturnContactServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param discountReturnContact ${table.comment}
   * @return
   */
  @GetMapping("/discountreturncontacts" )
  public XfR getDiscountReturnContacts(XfPage page, DiscountReturnContact discountReturnContact) {
    return XfR.ok(discountReturnContactServiceImpl.page(page, Wrappers.query(discountReturnContact)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/discountreturncontacts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(discountReturnContactServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param discountReturnContact ${table.comment}
   * @return XfR
   */
  @PostMapping("/discountreturncontacts")
  public XfR save(@RequestBody DiscountReturnContact discountReturnContact) {
     return XfR.ok(discountReturnContactServiceImpl.save(discountReturnContact));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param discountReturnContact ${table.comment}
   * @return XfR
   */
  @PutMapping("/discountreturncontacts/{id}")
  public XfR putUpdate(@RequestBody DiscountReturnContact discountReturnContact,@PathVariable Long id) {
      discountReturnContact.setId(id);
      return XfR.ok(discountReturnContactServiceImpl.updateById(discountReturnContact));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param discountReturnContact ${table.comment}
   * @return XfR
   */
  @PatchMapping("/discountreturncontacts/{id}")
  public XfR patchUpdate(@RequestBody DiscountReturnContact discountReturnContact,@PathVariable Long id) {
      DiscountReturnContact updiscountReturnContact = discountReturnContactServiceImpl.getById(id);
      if(updiscountReturnContact != null){
        updiscountReturnContact = ObjectCopyUtils.copyProperties(discountReturnContact,updiscountReturnContact,true);
      }
      return XfR.ok(discountReturnContactServiceImpl.updateById(updiscountReturnContact));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/discountreturncontacts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(discountReturnContactServiceImpl.removeById(id));
  }

  @PostMapping("/discountreturncontacts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "discount_return_contact");
     params.put("request", condition);

     return XfR.ok(discountReturnContactServiceImpl.querys(params));
  }

}
