package com.xforceplus.jcpolybuild.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2021-06-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcpolybuild.entity.TerminalInfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-poly-build")
public interface TerminalInfoFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/terminalInfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param terminalInfo ${table.comment}
   * @return R
   */
  @PostMapping("/terminalInfo/add")
  public R save(@RequestBody TerminalInfo terminalInfo);

  /**
   * 修改${table.comment}
   * @param terminalInfo ${table.comment}
   * @return R
   */
  @PostMapping("/terminalInfo/update")
  public R updateById(@RequestBody TerminalInfo terminalInfo);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/terminalInfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}