package com.xforceplus.jcpolybuild.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2021-06-25
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcpolybuild.entity.ApiLogs;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-poly-build")
public interface ApiLogsFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/apiLogs/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param apiLogs ${table.comment}
   * @return R
   */
  @PostMapping("/apiLogs/add")
  public R save(@RequestBody ApiLogs apiLogs);

  /**
   * 修改${table.comment}
   * @param apiLogs ${table.comment}
   * @return R
   */
  @PostMapping("/apiLogs/update")
  public R updateById(@RequestBody ApiLogs apiLogs);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/apiLogs/del/{id}" )
  public R removeById(@PathVariable Long id);

}