package com.xforceplus.jcpolybuild.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 红字信息表状态
 * </p>
 *
 * @author ultraman
 * @since 2021-05-08
 */
public enum ApplyStatus {

    _1("1", "待申请"),
    _2("2", "已申请"),
    _3("3", "审核通过"),
    _4("4", "已核销"),
    _5("5", "已撤销"),
    _6("6", "审核不通过"),
    _7("7", "申请失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ApplyStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
