package com.xforceplus.jcpolybuild.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcpolybuild.entity.RelationList;
import com.xforceplus.jcpolybuild.service.IRelationListService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-08
 */
@RestController
public class RelationListController {

  @Autowired
  private IRelationListService relationListServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param relationList ${table.comment}
   * @return
   */
  @GetMapping("/relationlists" )
  public XfR getRelationLists(XfPage page, RelationList relationList) {
    return XfR.ok(relationListServiceImpl.page(page, Wrappers.query(relationList)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/relationlists/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(relationListServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param relationList ${table.comment}
   * @return XfR
   */
  @PostMapping("/relationlists")
  public XfR save(@RequestBody RelationList relationList) {
     return XfR.ok(relationListServiceImpl.save(relationList));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param relationList ${table.comment}
   * @return XfR
   */
  @PutMapping("/relationlists/{id}")
  public XfR putUpdate(@RequestBody RelationList relationList,@PathVariable Long id) {
      relationList.setId(id);
      return XfR.ok(relationListServiceImpl.updateById(relationList));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param relationList ${table.comment}
   * @return XfR
   */
  @PatchMapping("/relationlists/{id}")
  public XfR patchUpdate(@RequestBody RelationList relationList,@PathVariable Long id) {
      RelationList uprelationList = relationListServiceImpl.getById(id);
      if(uprelationList != null){
        uprelationList = ObjectCopyUtils.copyProperties(relationList,uprelationList,true);
      }
      return XfR.ok(relationListServiceImpl.updateById(uprelationList));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/relationlists/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(relationListServiceImpl.removeById(id));
  }

  @PostMapping("/relationlists/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "relation_list");
     params.put("request", condition);

     return XfR.ok(relationListServiceImpl.querys(params));
  }

}
