package com.xforceplus.jcpolybuild.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcpolybuild.entity.RedLetters;
import com.xforceplus.jcpolybuild.service.IRedLettersService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-30
 */
@RestController
public class RedLettersController {

  @Autowired
  private IRedLettersService redLettersServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param redLetters ${table.comment}
   * @return
   */
  @GetMapping("/redletterss" )
  public XfR getRedLetterss(XfPage page, RedLetters redLetters) {
    return XfR.ok(redLettersServiceImpl.page(page, Wrappers.query(redLetters)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/redletterss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(redLettersServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param redLetters ${table.comment}
   * @return XfR
   */
  @PostMapping("/redletterss")
  public XfR save(@RequestBody RedLetters redLetters) {
     return XfR.ok(redLettersServiceImpl.save(redLetters));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param redLetters ${table.comment}
   * @return XfR
   */
  @PutMapping("/redletterss/{id}")
  public XfR putUpdate(@RequestBody RedLetters redLetters,@PathVariable Long id) {
      redLetters.setId(id);
      return XfR.ok(redLettersServiceImpl.updateById(redLetters));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param redLetters ${table.comment}
   * @return XfR
   */
  @PatchMapping("/redletterss/{id}")
  public XfR patchUpdate(@RequestBody RedLetters redLetters,@PathVariable Long id) {
      RedLetters upredLetters = redLettersServiceImpl.getById(id);
      if(upredLetters != null){
        upredLetters = ObjectCopyUtils.copyProperties(redLetters,upredLetters,true);
      }
      return XfR.ok(redLettersServiceImpl.updateById(upredLetters));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/redletterss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(redLettersServiceImpl.removeById(id));
  }

  @PostMapping("/redletterss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "red_letters");
     params.put("request", condition);

     return XfR.ok(redLettersServiceImpl.querys(params));
  }

}
