package com.xforceplus.jcrichemont.controller;


/**
 * 导入结算单明细信息feign客户端
 *
 * @author ultraman
 * @date 2024-07-05
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcrichemont.entity.BizOrderDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-richemont")
public interface BizOrderDetailFeignApi {

  /**
   * 通过id查询导入结算单明细信息
   * @param  id
   * @return R
   */
  @GetMapping("/bizOrderDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增导入结算单明细信息
   * @param bizOrderDetail 导入结算单明细信息
   * @return R
   */
  @PostMapping("/bizOrderDetail/add")
  public R save(@RequestBody BizOrderDetail bizOrderDetail);

  /**
   * 修改导入结算单明细信息
   * @param bizOrderDetail 导入结算单明细信息
   * @return R
   */
  @PostMapping("/bizOrderDetail/update")
  public R updateById(@RequestBody BizOrderDetail bizOrderDetail);

  /**
   * 通过id删除导入结算单明细信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/bizOrderDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}