package com.xforceplus.jcrichemont.controller;


/**
 * 订单主表feign客户端
 *
 * @author ultraman
 * @date 2024-07-05
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcrichemont.entity.OrderInfoMain;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-richemont")
public interface OrderInfoMainFeignApi {

  /**
   * 通过id查询订单主表
   * @param  id
   * @return R
   */
  @GetMapping("/orderInfoMain/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增订单主表
   * @param orderInfoMain 订单主表
   * @return R
   */
  @PostMapping("/orderInfoMain/add")
  public R save(@RequestBody OrderInfoMain orderInfoMain);

  /**
   * 修改订单主表
   * @param orderInfoMain 订单主表
   * @return R
   */
  @PostMapping("/orderInfoMain/update")
  public R updateById(@RequestBody OrderInfoMain orderInfoMain);

  /**
   * 通过id删除订单主表
   * @param  id
   * @return R
   */
  @DeleteMapping("/orderInfoMain/del/{id}" )
  public R removeById(@PathVariable Long id);

}