package com.xforceplus.jcrichemont.controller;


/**
 * 结算单主表feign客户端
 *
 * @author ultraman
 * @date 2024-07-05
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcrichemont.entity.SettlementMain;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-richemont")
public interface SettlementMainFeignApi {

  /**
   * 通过id查询结算单主表
   * @param  id
   * @return R
   */
  @GetMapping("/settlementMain/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增结算单主表
   * @param settlementMain 结算单主表
   * @return R
   */
  @PostMapping("/settlementMain/add")
  public R save(@RequestBody SettlementMain settlementMain);

  /**
   * 修改结算单主表
   * @param settlementMain 结算单主表
   * @return R
   */
  @PostMapping("/settlementMain/update")
  public R updateById(@RequestBody SettlementMain settlementMain);

  /**
   * 通过id删除结算单主表
   * @param  id
   * @return R
   */
  @DeleteMapping("/settlementMain/del/{id}" )
  public R removeById(@PathVariable Long id);

}