package com.xforceplus.jcrichemont.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcrichemont.entity.SellerInvoiceDetail;
import com.xforceplus.jcrichemont.service.ISellerInvoiceDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票明细表前端控制器
 *
 * @author ultraman
 * @date 2024-05-20
 */
@RestController
public class SellerInvoiceDetailController {

  @Autowired
  private ISellerInvoiceDetailService sellerInvoiceDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sellerInvoiceDetail 发票明细表
   * @return
   */
  @GetMapping("/sellerinvoicedetails" )
  public XfR getSellerInvoiceDetails(XfPage page, SellerInvoiceDetail sellerInvoiceDetail) {
    return XfR.ok(sellerInvoiceDetailServiceImpl.page(page, Wrappers.query(sellerInvoiceDetail)));
  }

  /**
   * 通过id查询发票明细表
   * @param  id
   * @return XfR
   */
  @GetMapping("/sellerinvoicedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sellerInvoiceDetailServiceImpl.getById(id));
  }

  /**
   * 新增发票明细表
   * @param sellerInvoiceDetail 发票明细表
   * @return XfR
   */
  @PostMapping("/sellerinvoicedetails")
  public XfR save(@RequestBody SellerInvoiceDetail sellerInvoiceDetail) {
     return XfR.ok(sellerInvoiceDetailServiceImpl.save(sellerInvoiceDetail));
  }

  /**
   * 修改-传入修改后的全部数据发票明细表
   * @param sellerInvoiceDetail 发票明细表
   * @return XfR
   */
  @PutMapping("/sellerinvoicedetails/{id}")
  public XfR putUpdate(@RequestBody SellerInvoiceDetail sellerInvoiceDetail,@PathVariable Long id) {
      sellerInvoiceDetail.setId(id);
      return XfR.ok(sellerInvoiceDetailServiceImpl.updateById(sellerInvoiceDetail));
  }

  /**
   * 修改-传入修改的数据发票明细表
   * @param sellerInvoiceDetail 发票明细表
   * @return XfR
   */
  @PatchMapping("/sellerinvoicedetails/{id}")
  public XfR patchUpdate(@RequestBody SellerInvoiceDetail sellerInvoiceDetail,@PathVariable Long id) {
      SellerInvoiceDetail upsellerInvoiceDetail = sellerInvoiceDetailServiceImpl.getById(id);
      if(upsellerInvoiceDetail != null){
        upsellerInvoiceDetail = ObjectCopyUtils.copyProperties(sellerInvoiceDetail,upsellerInvoiceDetail,true);
      }
      return XfR.ok(sellerInvoiceDetailServiceImpl.updateById(upsellerInvoiceDetail));
  }

  /**
   * 通过id删除发票明细表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sellerinvoicedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sellerInvoiceDetailServiceImpl.removeById(id));
  }

  @PostMapping("/sellerinvoicedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "seller_invoice_detail");
     params.put("request", condition);

     return XfR.ok(sellerInvoiceDetailServiceImpl.querys(params));
  }

}
