package com.xforceplus.jcrichemont.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcrichemont.entity.SettlementDetail;
import com.xforceplus.jcrichemont.service.ISettlementDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 结算单明细表前端控制器
 *
 * @author ultraman
 * @date 2024-05-20
 */
@RestController
public class SettlementDetailController {

  @Autowired
  private ISettlementDetailService settlementDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementDetail 结算单明细表
   * @return
   */
  @GetMapping("/settlementdetails" )
  public XfR getSettlementDetails(XfPage page, SettlementDetail settlementDetail) {
    return XfR.ok(settlementDetailServiceImpl.page(page, Wrappers.query(settlementDetail)));
  }

  /**
   * 通过id查询结算单明细表
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementDetailServiceImpl.getById(id));
  }

  /**
   * 新增结算单明细表
   * @param settlementDetail 结算单明细表
   * @return XfR
   */
  @PostMapping("/settlementdetails")
  public XfR save(@RequestBody SettlementDetail settlementDetail) {
     return XfR.ok(settlementDetailServiceImpl.save(settlementDetail));
  }

  /**
   * 修改-传入修改后的全部数据结算单明细表
   * @param settlementDetail 结算单明细表
   * @return XfR
   */
  @PutMapping("/settlementdetails/{id}")
  public XfR putUpdate(@RequestBody SettlementDetail settlementDetail,@PathVariable Long id) {
      settlementDetail.setId(id);
      return XfR.ok(settlementDetailServiceImpl.updateById(settlementDetail));
  }

  /**
   * 修改-传入修改的数据结算单明细表
   * @param settlementDetail 结算单明细表
   * @return XfR
   */
  @PatchMapping("/settlementdetails/{id}")
  public XfR patchUpdate(@RequestBody SettlementDetail settlementDetail,@PathVariable Long id) {
      SettlementDetail upsettlementDetail = settlementDetailServiceImpl.getById(id);
      if(upsettlementDetail != null){
        upsettlementDetail = ObjectCopyUtils.copyProperties(settlementDetail,upsettlementDetail,true);
      }
      return XfR.ok(settlementDetailServiceImpl.updateById(upsettlementDetail));
  }

  /**
   * 通过id删除结算单明细表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementDetailServiceImpl.removeById(id));
  }

  @PostMapping("/settlementdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_detail");
     params.put("request", condition);

     return XfR.ok(settlementDetailServiceImpl.querys(params));
  }

}
