package com.xforceplus.jcrichemont.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcrichemont.entity.SettlementNode;
import com.xforceplus.jcrichemont.service.ISettlementNodeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 结算单流水表前端控制器
 *
 * @author ultraman
 * @date 2024-05-20
 */
@RestController
public class SettlementNodeController {

  @Autowired
  private ISettlementNodeService settlementNodeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementNode 结算单流水表
   * @return
   */
  @GetMapping("/settlementnodes" )
  public XfR getSettlementNodes(XfPage page, SettlementNode settlementNode) {
    return XfR.ok(settlementNodeServiceImpl.page(page, Wrappers.query(settlementNode)));
  }

  /**
   * 通过id查询结算单流水表
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementnodes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementNodeServiceImpl.getById(id));
  }

  /**
   * 新增结算单流水表
   * @param settlementNode 结算单流水表
   * @return XfR
   */
  @PostMapping("/settlementnodes")
  public XfR save(@RequestBody SettlementNode settlementNode) {
     return XfR.ok(settlementNodeServiceImpl.save(settlementNode));
  }

  /**
   * 修改-传入修改后的全部数据结算单流水表
   * @param settlementNode 结算单流水表
   * @return XfR
   */
  @PutMapping("/settlementnodes/{id}")
  public XfR putUpdate(@RequestBody SettlementNode settlementNode,@PathVariable Long id) {
      settlementNode.setId(id);
      return XfR.ok(settlementNodeServiceImpl.updateById(settlementNode));
  }

  /**
   * 修改-传入修改的数据结算单流水表
   * @param settlementNode 结算单流水表
   * @return XfR
   */
  @PatchMapping("/settlementnodes/{id}")
  public XfR patchUpdate(@RequestBody SettlementNode settlementNode,@PathVariable Long id) {
      SettlementNode upsettlementNode = settlementNodeServiceImpl.getById(id);
      if(upsettlementNode != null){
        upsettlementNode = ObjectCopyUtils.copyProperties(settlementNode,upsettlementNode,true);
      }
      return XfR.ok(settlementNodeServiceImpl.updateById(upsettlementNode));
  }

  /**
   * 通过id删除结算单流水表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementnodes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementNodeServiceImpl.removeById(id));
  }

  @PostMapping("/settlementnodes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_node");
     params.put("request", condition);

     return XfR.ok(settlementNodeServiceImpl.querys(params));
  }

}
