package com.xforceplus.jcrichemont.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcrichemont.entity.OrderInfoMain;
import com.xforceplus.jcrichemont.service.IOrderInfoMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 订单主表前端控制器
 *
 * @author ultraman
 * @date 2024-03-18
 */
@RestController
public class OrderInfoMainController {

  @Autowired
  private IOrderInfoMainService orderInfoMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderInfoMain 订单主表
   * @return
   */
  @GetMapping("/orderinfomains" )
  public XfR getOrderInfoMains(XfPage page, OrderInfoMain orderInfoMain) {
    return XfR.ok(orderInfoMainServiceImpl.page(page, Wrappers.query(orderInfoMain)));
  }

  /**
   * 通过id查询订单主表
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderinfomains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderInfoMainServiceImpl.getById(id));
  }

  /**
   * 新增订单主表
   * @param orderInfoMain 订单主表
   * @return XfR
   */
  @PostMapping("/orderinfomains")
  public XfR save(@RequestBody OrderInfoMain orderInfoMain) {
     return XfR.ok(orderInfoMainServiceImpl.save(orderInfoMain));
  }

  /**
   * 修改-传入修改后的全部数据订单主表
   * @param orderInfoMain 订单主表
   * @return XfR
   */
  @PutMapping("/orderinfomains/{id}")
  public XfR putUpdate(@RequestBody OrderInfoMain orderInfoMain,@PathVariable Long id) {
      orderInfoMain.setId(id);
      return XfR.ok(orderInfoMainServiceImpl.updateById(orderInfoMain));
  }

  /**
   * 修改-传入修改的数据订单主表
   * @param orderInfoMain 订单主表
   * @return XfR
   */
  @PatchMapping("/orderinfomains/{id}")
  public XfR patchUpdate(@RequestBody OrderInfoMain orderInfoMain,@PathVariable Long id) {
      OrderInfoMain uporderInfoMain = orderInfoMainServiceImpl.getById(id);
      if(uporderInfoMain != null){
        uporderInfoMain = ObjectCopyUtils.copyProperties(orderInfoMain,uporderInfoMain,true);
      }
      return XfR.ok(orderInfoMainServiceImpl.updateById(uporderInfoMain));
  }

  /**
   * 通过id删除订单主表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderinfomains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderInfoMainServiceImpl.removeById(id));
  }

  @PostMapping("/orderinfomains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_info_main");
     params.put("request", condition);

     return XfR.ok(orderInfoMainServiceImpl.querys(params));
  }

}
