package com.xforceplus.jcrichemont.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcrichemont.entity.SettlementMain;
import com.xforceplus.jcrichemont.service.ISettlementMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 结算单主表前端控制器
 *
 * @author ultraman
 * @date 2024-03-18
 */
@RestController
public class SettlementMainController {

  @Autowired
  private ISettlementMainService settlementMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementMain 结算单主表
   * @return
   */
  @GetMapping("/settlementmains" )
  public XfR getSettlementMains(XfPage page, SettlementMain settlementMain) {
    return XfR.ok(settlementMainServiceImpl.page(page, Wrappers.query(settlementMain)));
  }

  /**
   * 通过id查询结算单主表
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementmains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementMainServiceImpl.getById(id));
  }

  /**
   * 新增结算单主表
   * @param settlementMain 结算单主表
   * @return XfR
   */
  @PostMapping("/settlementmains")
  public XfR save(@RequestBody SettlementMain settlementMain) {
     return XfR.ok(settlementMainServiceImpl.save(settlementMain));
  }

  /**
   * 修改-传入修改后的全部数据结算单主表
   * @param settlementMain 结算单主表
   * @return XfR
   */
  @PutMapping("/settlementmains/{id}")
  public XfR putUpdate(@RequestBody SettlementMain settlementMain,@PathVariable Long id) {
      settlementMain.setId(id);
      return XfR.ok(settlementMainServiceImpl.updateById(settlementMain));
  }

  /**
   * 修改-传入修改的数据结算单主表
   * @param settlementMain 结算单主表
   * @return XfR
   */
  @PatchMapping("/settlementmains/{id}")
  public XfR patchUpdate(@RequestBody SettlementMain settlementMain,@PathVariable Long id) {
      SettlementMain upsettlementMain = settlementMainServiceImpl.getById(id);
      if(upsettlementMain != null){
        upsettlementMain = ObjectCopyUtils.copyProperties(settlementMain,upsettlementMain,true);
      }
      return XfR.ok(settlementMainServiceImpl.updateById(upsettlementMain));
  }

  /**
   * 通过id删除结算单主表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementmains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementMainServiceImpl.removeById(id));
  }

  @PostMapping("/settlementmains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_main");
     params.put("request", condition);

     return XfR.ok(settlementMainServiceImpl.querys(params));
  }

}
