package com.xforceplus.jcseazen.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcseazen.entity.BillCheck;
import com.xforceplus.jcseazen.service.IBillCheckService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 单据稽核前端控制器
 *
 * @author ultraman
 * @date 2022-07-18
 */
@RestController
public class BillCheckController {

  @Autowired
  private IBillCheckService billCheckServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billCheck 单据稽核
   * @return
   */
  @GetMapping("/billchecks" )
  public XfR getBillChecks(XfPage page, BillCheck billCheck) {
    return XfR.ok(billCheckServiceImpl.page(page, Wrappers.query(billCheck)));
  }

  /**
   * 通过id查询单据稽核
   * @param  id
   * @return XfR
   */
  @GetMapping("/billchecks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billCheckServiceImpl.getById(id));
  }

  /**
   * 新增单据稽核
   * @param billCheck 单据稽核
   * @return XfR
   */
  @PostMapping("/billchecks")
  public XfR save(@RequestBody BillCheck billCheck) {
     return XfR.ok(billCheckServiceImpl.save(billCheck));
  }

  /**
   * 修改-传入修改后的全部数据单据稽核
   * @param billCheck 单据稽核
   * @return XfR
   */
  @PutMapping("/billchecks/{id}")
  public XfR putUpdate(@RequestBody BillCheck billCheck,@PathVariable Long id) {
      billCheck.setId(id);
      return XfR.ok(billCheckServiceImpl.updateById(billCheck));
  }

  /**
   * 修改-传入修改的数据单据稽核
   * @param billCheck 单据稽核
   * @return XfR
   */
  @PatchMapping("/billchecks/{id}")
  public XfR patchUpdate(@RequestBody BillCheck billCheck,@PathVariable Long id) {
      BillCheck upbillCheck = billCheckServiceImpl.getById(id);
      if(upbillCheck != null){
        upbillCheck = ObjectCopyUtils.copyProperties(billCheck,upbillCheck,true);
      }
      return XfR.ok(billCheckServiceImpl.updateById(upbillCheck));
  }

  /**
   * 通过id删除单据稽核
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billchecks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billCheckServiceImpl.removeById(id));
  }

  @PostMapping("/billchecks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_check");
     params.put("request", condition);

     return XfR.ok(billCheckServiceImpl.querys(params));
  }

}
