package com.xforceplus.jcsmec.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-10-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceMain implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 进项发票ID
   */
  @TableField("purInvoiceId")
  private String purInvoiceId;

  /**
   * 协同发票ID
   */
  @TableField("antInvoiceId")
  private String antInvoiceId;

  /**
   * 影像发票ID
   */
  @TableField("imgInvoiceId")
  private String imgInvoiceId;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 开票日期
   */
  @TableField("paperDrewDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paperDrewDate;

  /**
   * 发票状态
   */
  @TableField("invoiceStatus")
  private String invoiceStatus;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 综合税率
   */
  @TableField("taxRate")
  private String taxRate;

  /**
   * 购方公司税号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 购方公司名称
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 销方公司税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 销方公司名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 扫描日期
   */
  @TableField("scanTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime scanTime;

  /**
   * 影像地址
   */
  @TableField("imageUrl")
  private String imageUrl;

  /**
   * 业务单号
   */
  @TableField("salesbillNo")
  private String salesbillNo;

  /**
   * 结算单号
   */
  @TableField("settlementNo")
  private String settlementNo;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 购方公司编号
   */
  @TableField("purchaserNo")
  private String purchaserNo;

  /**
   * 销方公司编号
   */
  @TableField("sellerNo")
  private String sellerNo;

  /**
   * 扩展字段1
   */
  private String ext1;

  /**
   * 扩展字段2
   */
  private String ext2;

  /**
   * 扩展字段3
   */
  private String ext3;

  /**
   * 扩展字段4
   */
  private String ext4;

  /**
   * 扩展字段5
   */
  private String ext5;

  /**
   * 扩展字段6
   */
  private String ext6;

  /**
   * 扩展字段7
   */
  private String ext7;

  /**
   * 扩展字段8
   */
  private String ext8;

  /**
   * 扩展字段9
   */
  private String ext9;

  /**
   * 扩展字段10
   */
  private String ext10;

  /**
   * 扩展字段11
   */
  private String ext11;

  /**
   * 扩展字段12
   */
  private String ext12;

  /**
   * 扩展字段13
   */
  private String ext13;

  /**
   * 扩展字段14
   */
  private String ext14;

  /**
   * 扩展字段15
   */
  private String ext15;

  /**
   * 扩展字段16
   */
  private String ext16;

  /**
   * 扩展字段17
   */
  private String ext17;

  /**
   * 扩展字段18
   */
  private String ext18;

  /**
   * 扩展字段19
   */
  private String ext19;

  /**
   * 扩展字段20
   */
  private String ext20;

  /**
   * 扩展字段21
   */
  private String ext21;

  /**
   * 扩展字段22
   */
  private String ext22;

  /**
   * 扩展字段23
   */
  private String ext23;

  /**
   * 扩展字段24
   */
  private String ext24;

  /**
   * 扩展字段25
   */
  private String ext25;

  /**
   * 红冲状态
   */
  @TableField("redStatus")
  private String redStatus;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("purInvoiceId", purInvoiceId);
      map.put("antInvoiceId", antInvoiceId);
      map.put("imgInvoiceId", imgInvoiceId);
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceCode", invoiceCode);
      map.put("paperDrewDate", BocpGenUtils.toTimestamp(paperDrewDate));
      map.put("invoiceStatus", invoiceStatus);
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("taxRate", taxRate);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserName", purchaserName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerName", sellerName);
      map.put("scanTime", BocpGenUtils.toTimestamp(scanTime));
      map.put("imageUrl", imageUrl);
      map.put("salesbillNo", salesbillNo);
      map.put("settlementNo", settlementNo);
      map.put("invoiceType", invoiceType);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("purchaserNo", purchaserNo);
      map.put("sellerNo", sellerNo);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("ext11", ext11);
      map.put("ext12", ext12);
      map.put("ext13", ext13);
      map.put("ext14", ext14);
      map.put("ext15", ext15);
      map.put("ext16", ext16);
      map.put("ext17", ext17);
      map.put("ext18", ext18);
      map.put("ext19", ext19);
      map.put("ext20", ext20);
      map.put("ext21", ext21);
      map.put("ext22", ext22);
      map.put("ext23", ext23);
      map.put("ext24", ext24);
      map.put("ext25", ext25);
      map.put("redStatus", redStatus);
      return map;
  }

  public static InvoiceMain fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceMain entity = new InvoiceMain();
    if(map.containsKey("purInvoiceId")) {
      Object obj = map.get("purInvoiceId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("antInvoiceId")) {
      Object obj = map.get("antInvoiceId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAntInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("imgInvoiceId")) {
      Object obj = map.get("imgInvoiceId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImgInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperDrewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaperDrewDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaperDrewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaperDrewDate(null);
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scanTime")) {
      Object obj = map.get("scanTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScanTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setScanTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setScanTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setScanTime(null);
      }
    }
    if(map.containsKey("imageUrl")) {
      Object obj = map.get("imageUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementNo")) {
      Object obj = map.get("settlementNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt11((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt12((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt13((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt14((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt15((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt16((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt17((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt18((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt19((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt20((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt21((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt22((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt23((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt24((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt25((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redStatus")) {
      Object obj = map.get("redStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedStatus((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
