package com.xforceplus.jcsmec.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-10-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SalesBillItem implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务单号
   */
  @TableField("salesBillBo")
  private String salesBillBo;

  /**
   * 业务单明细号
   */
  @TableField("salesBillItemNo")
  private String salesBillItemNo;

  /**
   * 价格方式
   */
  @TableField("priceMethod")
  private String priceMethod;

  /**
   * 税编转换代码
   */
  @TableField("taxConvertCode")
  private String taxConvertCode;

  /**
   * 货物及服务名称
   */
  @TableField("itemName")
  private String itemName;

  /**
   * 数量单位
   */
  @TableField("quantityUnit")
  private String quantityUnit;

  /**
   * 型号规格
   */
  @TableField("itemSpec")
  private String itemSpec;

  /**
   * 数量
   */
  private BigDecimal quantity;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * 不含税金额 
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 价内含税折扣金额
   */
  @TableField("innerDiscountWithTax")
  private BigDecimal innerDiscountWithTax;

  /**
   * 价内不含税折扣金额
   */
  @TableField("innerDiscountWithoutTax")
  private BigDecimal innerDiscountWithoutTax;

  /**
   * 价外含税折扣金额
   */
  @TableField("outterDiscountWithTax")
  private BigDecimal outterDiscountWithTax;

  /**
   * 价外不含税折扣金额
   */
  @TableField("outterDiscountWithoutTax")
  private BigDecimal outterDiscountWithoutTax;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 备注
   */
  private String remark;

  /**
   * 是否享受税收优惠政策
   */
  @TableField("taxPre")
  private String taxPre;

  /**
   * 税收优惠
   */
  @TableField("taxPreCon")
  private String taxPreCon;

  /**
   * 零税率标志
   */
  @TableField("zeroTax")
  private String zeroTax;

  /**
   * 价内折扣税额
   */
  @TableField("innerDiscountTax")
  private BigDecimal innerDiscountTax;

  /**
   * 价外折扣税额
   */
  @TableField("outterDiscountTax")
  private BigDecimal outterDiscountTax;

  /**
   * 扩展字段1
   */
  private String ext1;

  /**
   * 扩展字段2
   */
  private String ext2;

  /**
   * 扩展字段3
   */
  private String ext3;

  /**
   * 扩展字段4
   */
  private String ext4;

  /**
   * 扩展字段5
   */
  private String ext5;

  /**
   * 扩展字段6
   */
  private String ext6;

  /**
   * 扩展字段7
   */
  private String ext7;

  /**
   * 扩展字段8
   */
  private String ext8;

  /**
   * 扩展字段9
   */
  private String ext9;

  /**
   * 扩展字段10
   */
  private String ext10;

  /**
   * 扩展字段11
   */
  private String ext11;

  /**
   * 扩展字段12
   */
  private String ext12;

  /**
   * 扩展字段13
   */
  private String ext13;

  /**
   * 扩展字段14
   */
  private String ext14;

  /**
   * 扩展字段15
   */
  private String ext15;

  /**
   * 扩展字段16
   */
  private String ext16;

  /**
   * 扩展字段17
   */
  private String ext17;

  /**
   * 扩展字段18
   */
  private String ext18;

  /**
   * 扩展字段19
   */
  private String ext19;

  /**
   * 扩展字段20
   */
  private String ext20;

  /**
   * 扩展字段21
   */
  private String ext21;

  /**
   * 扩展字段22
   */
  private String ext22;

  /**
   * 扩展字段23
   */
  private String ext23;

  /**
   * 扩展字段24
   */
  private String ext24;

  /**
   * 扩展字段25
   */
  private String ext25;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 单价
   */
  @TableField("unitPrice")
  private BigDecimal unitPrice;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("salesBillBo", salesBillBo);
      map.put("salesBillItemNo", salesBillItemNo);
      map.put("priceMethod", priceMethod);
      map.put("taxConvertCode", taxConvertCode);
      map.put("itemName", itemName);
      map.put("quantityUnit", quantityUnit);
      map.put("itemSpec", itemSpec);
      map.put("quantity", quantity);
      map.put("taxRate", taxRate);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("innerDiscountWithTax", innerDiscountWithTax);
      map.put("innerDiscountWithoutTax", innerDiscountWithoutTax);
      map.put("outterDiscountWithTax", outterDiscountWithTax);
      map.put("outterDiscountWithoutTax", outterDiscountWithoutTax);
      map.put("amountWithTax", amountWithTax);
      map.put("taxAmount", taxAmount);
      map.put("remark", remark);
      map.put("taxPre", taxPre);
      map.put("taxPreCon", taxPreCon);
      map.put("zeroTax", zeroTax);
      map.put("innerDiscountTax", innerDiscountTax);
      map.put("outterDiscountTax", outterDiscountTax);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("ext11", ext11);
      map.put("ext12", ext12);
      map.put("ext13", ext13);
      map.put("ext14", ext14);
      map.put("ext15", ext15);
      map.put("ext16", ext16);
      map.put("ext17", ext17);
      map.put("ext18", ext18);
      map.put("ext19", ext19);
      map.put("ext20", ext20);
      map.put("ext21", ext21);
      map.put("ext22", ext22);
      map.put("ext23", ext23);
      map.put("ext24", ext24);
      map.put("ext25", ext25);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("unitPrice", unitPrice);
      return map;
  }

  public static SalesBillItem fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SalesBillItem entity = new SalesBillItem();
    if(map.containsKey("salesBillBo")) {
      Object obj = map.get("salesBillBo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesBillBo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesBillItemNo")) {
      Object obj = map.get("salesBillItemNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesBillItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceMethod")) {
      Object obj = map.get("priceMethod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPriceMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxConvertCode")) {
      Object obj = map.get("taxConvertCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxConvertCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSpec")) {
      Object obj = map.get("itemSpec");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountWithTax")) {
      Object obj = map.get("innerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInnerDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountWithoutTax")) {
      Object obj = map.get("innerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInnerDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountWithTax")) {
      Object obj = map.get("outterDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOutterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountWithoutTax")) {
      Object obj = map.get("outterDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOutterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPre")) {
      Object obj = map.get("taxPre");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxPre((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPreCon")) {
      Object obj = map.get("taxPreCon");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxPreCon((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zeroTax")) {
      Object obj = map.get("zeroTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZeroTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountTax")) {
      Object obj = map.get("innerDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInnerDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountTax")) {
      Object obj = map.get("outterDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOutterDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt11((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt12((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt13((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt14((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt15((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt16((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt17((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt18((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt19((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt20((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt21((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt22((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt23((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt24((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt25((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    return entity;
  }
}
