package com.xforceplus.jcsmec.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-10-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SalesMaterial implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 年度
   */
  private String year;

  /**
   * 物料凭证
   */
  @TableField("materialVoucher")
  private String materialVoucher;

  /**
   * 采购订单
   */
  @TableField("purchaseOrder")
  private String purchaseOrder;

  /**
   * 装运通知单
   */
  @TableField("shippingNotice")
  private String shippingNotice;

  /**
   * 采购组织代码
   */
  @TableField("purchasingGroupNo")
  private String purchasingGroupNo;

  /**
   * 业务类型
   */
  @TableField("salesType")
  private String salesType;

  /**
   * 业务单号
   */
  @TableField("salesBillNo")
  private String salesBillNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private String amountWithTax;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private String amountWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private String taxAmount;

  /**
   * 供应商代码
   */
  @TableField("supplierNo")
  private String supplierNo;

  /**
   * 公司代码
   */
  @TableField("companyNo")
  private String companyNo;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("year", year);
      map.put("materialVoucher", materialVoucher);
      map.put("purchaseOrder", purchaseOrder);
      map.put("shippingNotice", shippingNotice);
      map.put("purchasingGroupNo", purchasingGroupNo);
      map.put("salesType", salesType);
      map.put("salesBillNo", salesBillNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("supplierNo", supplierNo);
      map.put("companyNo", companyNo);
      return map;
  }

  public static SalesMaterial fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SalesMaterial entity = new SalesMaterial();
    if(map.containsKey("year")) {
      Object obj = map.get("year");
      if(obj != null) {
        if(obj instanceof String){
          entity.setYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialVoucher")) {
      Object obj = map.get("materialVoucher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseOrder")) {
      Object obj = map.get("purchaseOrder");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shippingNotice")) {
      Object obj = map.get("shippingNotice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setShippingNotice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingGroupNo")) {
      Object obj = map.get("purchasingGroupNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchasingGroupNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesType")) {
      Object obj = map.get("salesType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesBillNo")) {
      Object obj = map.get("salesBillNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierNo")) {
      Object obj = map.get("supplierNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyNo")) {
      Object obj = map.get("companyNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyNo((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
