package com.xforceplus.jcsmec.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * send_priority
 * </p>
 *
 * @author ultraman
 * @since 2023-12-01
 */
public enum SendPriority {

    PAPER_DREW_DATE("paperDrewDate", "开票日期"),
    IS_DISCOUNT("isDiscount", "提前付款");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SendPriority(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SendPriority fromCode(String code){
        switch(code) {
            case "paperDrewDate":
                return PAPER_DREW_DATE;
            case "isDiscount":
                return IS_DISCOUNT;
            default:
                return null;
        }
    }
}
