package com.xforceplus.jcsmec.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-12-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SalesMaterialItem implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * 物料凭证行项目
   */
  @TableField("materialVoucherLineItem")
  private String materialVoucherLineItem;

  /**
   * 年度
   */
  private String year;

  /**
   * 物料凭证
   */
  @TableField("materialVoucher")
  private String materialVoucher;

  /**
   * 行项目
   */
  @TableField("lineItem")
  private String lineItem;

  /**
   * 采购订单
   */
  @TableField("purchaseOrder")
  private String purchaseOrder;

  /**
   * 单位
   */
  @TableField("quantityUnit")
  private String quantityUnit;

  /**
   * 数量
   */
  private BigDecimal quantity;

  /**
   * 物料
   */
  private String material;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 装运通知单
   */
  @TableField("shippingNotice")
  private String shippingNotice;

  /**
   * 内向交货单
   */
  @TableField("inboundDelivery")
  private String inboundDelivery;

  /**
   * 订单行项目
   */
  @TableField("orderLineItem")
  private String orderLineItem;

  /**
   * 采购组织代码
   */
  @TableField("purchasingGroupNo")
  private String purchasingGroupNo;

  /**
   * 预处理状态
   */
  @TableField("flowStatus")
  private String flowStatus;

  /**
   * 业务类型
   */
  @TableField("salesType")
  private String salesType;

  /**
   * 业务单号
   */
  @TableField("salesBillNo")
  private String salesBillNo;

  /**
   * 缺失信息
   */
  @TableField("absentMessage")
  private String absentMessage;

  /**
   * 单价
   */
  @TableField("unitPrice")
  private BigDecimal unitPrice;

  /**
   * 净价（不含税）
   */
  @TableField("netPrice")
  private BigDecimal netPrice;

  /**
   * 服务条目
   */
  @TableField("serviceEntry")
  private String serviceEntry;

  /**
   * 物料描述
   */
  @TableField("materialDescribe")
  private String materialDescribe;

  /**
   * 物料编号
   */
  @TableField("materialNo")
  private String materialNo;

  /**
   * 供应商代码
   */
  @TableField("supplierNo")
  private String supplierNo;

  /**
   * 公司代码
   */
  @TableField("companyNo")
  private String companyNo;

  /**
   * 业务类型描述
   */
  @TableField("salesTypeDesc")
  private String salesTypeDesc;

  /**
   * 提货单
   */
  @TableField("receiptGoodsBill")
  private String receiptGoodsBill;


  /**
   * 对一关联关系 关联对象 salesMaterial
   */
    private Long salesMaterialAndItemId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("taxRate", taxRate);
      map.put("materialVoucherLineItem", materialVoucherLineItem);
      map.put("year", year);
      map.put("materialVoucher", materialVoucher);
      map.put("lineItem", lineItem);
      map.put("purchaseOrder", purchaseOrder);
      map.put("quantityUnit", quantityUnit);
      map.put("quantity", quantity);
      map.put("material", material);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("shippingNotice", shippingNotice);
      map.put("inboundDelivery", inboundDelivery);
      map.put("orderLineItem", orderLineItem);
      map.put("purchasingGroupNo", purchasingGroupNo);
      map.put("flowStatus", flowStatus);
      map.put("salesType", salesType);
      map.put("salesBillNo", salesBillNo);
      map.put("absentMessage", absentMessage);
      map.put("unitPrice", unitPrice);
      map.put("netPrice", netPrice);
      map.put("serviceEntry", serviceEntry);
      map.put("materialDescribe", materialDescribe);
      map.put("materialNo", materialNo);
      map.put("supplierNo", supplierNo);
      map.put("companyNo", companyNo);
      map.put("salesTypeDesc", salesTypeDesc);
      map.put("receiptGoodsBill", receiptGoodsBill);

       map.put("salesMaterialAndItem.id", salesMaterialAndItemId);
      return map;
  }

  public static SalesMaterialItem fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SalesMaterialItem entity = new SalesMaterialItem();
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("materialVoucherLineItem")) {
      Object obj = map.get("materialVoucherLineItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialVoucherLineItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("year")) {
      Object obj = map.get("year");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialVoucher")) {
      Object obj = map.get("materialVoucher");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lineItem")) {
      Object obj = map.get("lineItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLineItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseOrder")) {
      Object obj = map.get("purchaseOrder");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("material")) {
      Object obj = map.get("material");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterial((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shippingNotice")) {
      Object obj = map.get("shippingNotice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShippingNotice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inboundDelivery")) {
      Object obj = map.get("inboundDelivery");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInboundDelivery((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderLineItem")) {
      Object obj = map.get("orderLineItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderLineItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasingGroupNo")) {
      Object obj = map.get("purchasingGroupNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchasingGroupNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flowStatus")) {
      Object obj = map.get("flowStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlowStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesType")) {
      Object obj = map.get("salesType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesBillNo")) {
      Object obj = map.get("salesBillNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("absentMessage")) {
      Object obj = map.get("absentMessage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAbsentMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("netPrice")) {
      Object obj = map.get("netPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNetPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNetPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNetPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNetPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNetPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("serviceEntry")) {
      Object obj = map.get("serviceEntry");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setServiceEntry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialDescribe")) {
      Object obj = map.get("materialDescribe");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialDescribe((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialNo")) {
      Object obj = map.get("materialNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierNo")) {
      Object obj = map.get("supplierNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyNo")) {
      Object obj = map.get("companyNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesTypeDesc")) {
      Object obj = map.get("salesTypeDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiptGoodsBill")) {
      Object obj = map.get("receiptGoodsBill");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiptGoodsBill((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("salesMaterialAndItem.id")) {
        Object obj = map.get("salesMaterialAndItem.id");
      if(obj instanceof Long) {
        entity.setSalesMaterialAndItemId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setSalesMaterialAndItemId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("materialVoucherLineItem")) {
      Object obj = map.get("materialVoucherLineItem");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterialVoucherLineItem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("year")) {
      Object obj = map.get("year");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYear((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("materialVoucher")) {
      Object obj = map.get("materialVoucher");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterialVoucher((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lineItem")) {
      Object obj = map.get("lineItem");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLineItem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseOrder")) {
      Object obj = map.get("purchaseOrder");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseOrder((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQuantityUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("material")) {
      Object obj = map.get("material");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterial((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shippingNotice")) {
      Object obj = map.get("shippingNotice");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShippingNotice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inboundDelivery")) {
      Object obj = map.get("inboundDelivery");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInboundDelivery((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderLineItem")) {
      Object obj = map.get("orderLineItem");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderLineItem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchasingGroupNo")) {
      Object obj = map.get("purchasingGroupNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchasingGroupNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("flowStatus")) {
      Object obj = map.get("flowStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFlowStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesType")) {
      Object obj = map.get("salesType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesBillNo")) {
      Object obj = map.get("salesBillNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesBillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("absentMessage")) {
      Object obj = map.get("absentMessage");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAbsentMessage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("netPrice")) {
      Object obj = map.get("netPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setNetPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setNetPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setNetPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setNetPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setNetPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("serviceEntry")) {
      Object obj = map.get("serviceEntry");
      if(obj != null) {
        if(obj instanceof String) {
          this.setServiceEntry((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("materialDescribe")) {
      Object obj = map.get("materialDescribe");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterialDescribe((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("materialNo")) {
      Object obj = map.get("materialNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterialNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierNo")) {
      Object obj = map.get("supplierNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyNo")) {
      Object obj = map.get("companyNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesTypeDesc")) {
      Object obj = map.get("salesTypeDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesTypeDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiptGoodsBill")) {
      Object obj = map.get("receiptGoodsBill");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiptGoodsBill((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("salesMaterialAndItem.id")) {
        Object obj = map.get("salesMaterialAndItem.id");
        if(obj instanceof Long) {
          this.setSalesMaterialAndItemId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesMaterialAndItemId(Long.parseLong((String)obj));
        }
      }
  }
}
