package com.xforceplus.jcsmec.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcsmec.entity.DisInvConfig;
import com.xforceplus.jcsmec.service.IDisInvConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-07
 */
@RestController
public class DisInvConfigController {

  @Autowired
  private IDisInvConfigService disInvConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param disInvConfig ${table.comment}
   * @return
   */
  @GetMapping("/disinvconfigs" )
  public XfR getDisInvConfigs(XfPage page, DisInvConfig disInvConfig) {
    return XfR.ok(disInvConfigServiceImpl.page(page, Wrappers.query(disInvConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/disinvconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(disInvConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param disInvConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/disinvconfigs")
  public XfR save(@RequestBody DisInvConfig disInvConfig) {
     return XfR.ok(disInvConfigServiceImpl.save(disInvConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param disInvConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/disinvconfigs/{id}")
  public XfR putUpdate(@RequestBody DisInvConfig disInvConfig,@PathVariable Long id) {
      disInvConfig.setId(id);
      return XfR.ok(disInvConfigServiceImpl.updateById(disInvConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param disInvConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/disinvconfigs/{id}")
  public XfR patchUpdate(@RequestBody DisInvConfig disInvConfig,@PathVariable Long id) {
      DisInvConfig updisInvConfig = disInvConfigServiceImpl.getById(id);
      if(updisInvConfig != null){
        updisInvConfig = ObjectCopyUtils.copyProperties(disInvConfig,updisInvConfig,true);
      }
      return XfR.ok(disInvConfigServiceImpl.updateById(updisInvConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/disinvconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(disInvConfigServiceImpl.removeById(id));
  }

  @PostMapping("/disinvconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "dis_inv_config");
     params.put("request", condition);

     return XfR.ok(disInvConfigServiceImpl.querys(params));
  }

}
