package com.xforceplus.jcsmec.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcsmec.entity.InvEmailConfig;
import com.xforceplus.jcsmec.service.IInvEmailConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-10-19
 */
@RestController
public class InvEmailConfigController {

  @Autowired
  private IInvEmailConfigService invEmailConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invEmailConfig ${table.comment}
   * @return
   */
  @GetMapping("/invemailconfigs" )
  public XfR getInvEmailConfigs(XfPage page, InvEmailConfig invEmailConfig) {
    return XfR.ok(invEmailConfigServiceImpl.page(page, Wrappers.query(invEmailConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invemailconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invEmailConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invEmailConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/invemailconfigs")
  public XfR save(@RequestBody InvEmailConfig invEmailConfig) {
     return XfR.ok(invEmailConfigServiceImpl.save(invEmailConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invEmailConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/invemailconfigs/{id}")
  public XfR putUpdate(@RequestBody InvEmailConfig invEmailConfig,@PathVariable Long id) {
      invEmailConfig.setId(id);
      return XfR.ok(invEmailConfigServiceImpl.updateById(invEmailConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invEmailConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invemailconfigs/{id}")
  public XfR patchUpdate(@RequestBody InvEmailConfig invEmailConfig,@PathVariable Long id) {
      InvEmailConfig upinvEmailConfig = invEmailConfigServiceImpl.getById(id);
      if(upinvEmailConfig != null){
        upinvEmailConfig = ObjectCopyUtils.copyProperties(invEmailConfig,upinvEmailConfig,true);
      }
      return XfR.ok(invEmailConfigServiceImpl.updateById(upinvEmailConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invemailconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invEmailConfigServiceImpl.removeById(id));
  }

  @PostMapping("/invemailconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inv_email_config");
     params.put("request", condition);

     return XfR.ok(invEmailConfigServiceImpl.querys(params));
  }

}
