package com.xforceplus.jcsmec.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcsmec.entity.InvoiceMain;
import com.xforceplus.jcsmec.service.IInvoiceMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-10-19
 */
@RestController
public class InvoiceMainController {

  @Autowired
  private IInvoiceMainService invoiceMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceMain ${table.comment}
   * @return
   */
  @GetMapping("/invoicemains" )
  public XfR getInvoiceMains(XfPage page, InvoiceMain invoiceMain) {
    return XfR.ok(invoiceMainServiceImpl.page(page, Wrappers.query(invoiceMain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicemains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceMainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceMain ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicemains")
  public XfR save(@RequestBody InvoiceMain invoiceMain) {
     return XfR.ok(invoiceMainServiceImpl.save(invoiceMain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceMain ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicemains/{id}")
  public XfR putUpdate(@RequestBody InvoiceMain invoiceMain,@PathVariable Long id) {
      invoiceMain.setId(id);
      return XfR.ok(invoiceMainServiceImpl.updateById(invoiceMain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceMain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicemains/{id}")
  public XfR patchUpdate(@RequestBody InvoiceMain invoiceMain,@PathVariable Long id) {
      InvoiceMain upinvoiceMain = invoiceMainServiceImpl.getById(id);
      if(upinvoiceMain != null){
        upinvoiceMain = ObjectCopyUtils.copyProperties(invoiceMain,upinvoiceMain,true);
      }
      return XfR.ok(invoiceMainServiceImpl.updateById(upinvoiceMain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicemains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceMainServiceImpl.removeById(id));
  }

  @PostMapping("/invoicemains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_main");
     params.put("request", condition);

     return XfR.ok(invoiceMainServiceImpl.querys(params));
  }

}
