package com.xforceplus.jcsmec.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcsmec.entity.SalesBillMain;
import com.xforceplus.jcsmec.service.ISalesBillMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-10-19
 */
@RestController
public class SalesBillMainController {

  @Autowired
  private ISalesBillMainService salesBillMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesBillMain ${table.comment}
   * @return
   */
  @GetMapping("/salesbillmains" )
  public XfR getSalesBillMains(XfPage page, SalesBillMain salesBillMain) {
    return XfR.ok(salesBillMainServiceImpl.page(page, Wrappers.query(salesBillMain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesbillmains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesBillMainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param salesBillMain ${table.comment}
   * @return XfR
   */
  @PostMapping("/salesbillmains")
  public XfR save(@RequestBody SalesBillMain salesBillMain) {
     return XfR.ok(salesBillMainServiceImpl.save(salesBillMain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param salesBillMain ${table.comment}
   * @return XfR
   */
  @PutMapping("/salesbillmains/{id}")
  public XfR putUpdate(@RequestBody SalesBillMain salesBillMain,@PathVariable Long id) {
      salesBillMain.setId(id);
      return XfR.ok(salesBillMainServiceImpl.updateById(salesBillMain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param salesBillMain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/salesbillmains/{id}")
  public XfR patchUpdate(@RequestBody SalesBillMain salesBillMain,@PathVariable Long id) {
      SalesBillMain upsalesBillMain = salesBillMainServiceImpl.getById(id);
      if(upsalesBillMain != null){
        upsalesBillMain = ObjectCopyUtils.copyProperties(salesBillMain,upsalesBillMain,true);
      }
      return XfR.ok(salesBillMainServiceImpl.updateById(upsalesBillMain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesbillmains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesBillMainServiceImpl.removeById(id));
  }

  @PostMapping("/salesbillmains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_bill_main");
     params.put("request", condition);

     return XfR.ok(salesBillMainServiceImpl.querys(params));
  }

}
