package com.xforceplus.jcsmec.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcsmec.entity.InvQuotaConfig;
import com.xforceplus.jcsmec.service.IInvQuotaConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-11-28
 */
@RestController
public class InvQuotaConfigController {

  @Autowired
  private IInvQuotaConfigService invQuotaConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invQuotaConfig ${table.comment}
   * @return
   */
  @GetMapping("/invquotaconfigs" )
  public XfR getInvQuotaConfigs(XfPage page, InvQuotaConfig invQuotaConfig) {
    return XfR.ok(invQuotaConfigServiceImpl.page(page, Wrappers.query(invQuotaConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invquotaconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invQuotaConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invQuotaConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/invquotaconfigs")
  public XfR save(@RequestBody InvQuotaConfig invQuotaConfig) {
     return XfR.ok(invQuotaConfigServiceImpl.save(invQuotaConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invQuotaConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/invquotaconfigs/{id}")
  public XfR putUpdate(@RequestBody InvQuotaConfig invQuotaConfig,@PathVariable Long id) {
      invQuotaConfig.setId(id);
      return XfR.ok(invQuotaConfigServiceImpl.updateById(invQuotaConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invQuotaConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invquotaconfigs/{id}")
  public XfR patchUpdate(@RequestBody InvQuotaConfig invQuotaConfig,@PathVariable Long id) {
      InvQuotaConfig upinvQuotaConfig = invQuotaConfigServiceImpl.getById(id);
      if(upinvQuotaConfig != null){
        upinvQuotaConfig = ObjectCopyUtils.copyProperties(invQuotaConfig,upinvQuotaConfig,true);
      }
      return XfR.ok(invQuotaConfigServiceImpl.updateById(upinvQuotaConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invquotaconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invQuotaConfigServiceImpl.removeById(id));
  }

  @PostMapping("/invquotaconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inv_quota_config");
     params.put("request", condition);

     return XfR.ok(invQuotaConfigServiceImpl.querys(params));
  }

}
