package com.xforceplus.jcsmec.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcsmec.entity.AmountUpdateRecord;
import com.xforceplus.jcsmec.service.IAmountUpdateRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-01-05
 */
@RestController
public class AmountUpdateRecordController {

  @Autowired
  private IAmountUpdateRecordService amountUpdateRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param amountUpdateRecord ${table.comment}
   * @return
   */
  @GetMapping("/amountupdaterecords" )
  public XfR getAmountUpdateRecords(XfPage page, AmountUpdateRecord amountUpdateRecord) {
    return XfR.ok(amountUpdateRecordServiceImpl.page(page, Wrappers.query(amountUpdateRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/amountupdaterecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(amountUpdateRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param amountUpdateRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/amountupdaterecords")
  public XfR save(@RequestBody AmountUpdateRecord amountUpdateRecord) {
     return XfR.ok(amountUpdateRecordServiceImpl.save(amountUpdateRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param amountUpdateRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/amountupdaterecords/{id}")
  public XfR putUpdate(@RequestBody AmountUpdateRecord amountUpdateRecord,@PathVariable Long id) {
      amountUpdateRecord.setId(id);
      return XfR.ok(amountUpdateRecordServiceImpl.updateById(amountUpdateRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param amountUpdateRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/amountupdaterecords/{id}")
  public XfR patchUpdate(@RequestBody AmountUpdateRecord amountUpdateRecord,@PathVariable Long id) {
      AmountUpdateRecord upamountUpdateRecord = amountUpdateRecordServiceImpl.getById(id);
      if(upamountUpdateRecord != null){
        upamountUpdateRecord = ObjectCopyUtils.copyProperties(amountUpdateRecord,upamountUpdateRecord,true);
      }
      return XfR.ok(amountUpdateRecordServiceImpl.updateById(upamountUpdateRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/amountupdaterecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(amountUpdateRecordServiceImpl.removeById(id));
  }

  @PostMapping("/amountupdaterecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "amount_update_record");
     params.put("request", condition);

     return XfR.ok(amountUpdateRecordServiceImpl.querys(params));
  }

}
