package com.xforceplus.jcsmjt.controller;


/**
 * 业务单表feign客户端
 *
 * @author ultraman
 * @date 2021-12-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcsmjt.entity.BusinessBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-smjt")
public interface BusinessBillFeignApi {

  /**
   * 通过id查询业务单表
   * @param  id
   * @return R
   */
  @GetMapping("/businessBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增业务单表
   * @param businessBill 业务单表
   * @return R
   */
  @PostMapping("/businessBill/add")
  public R save(@RequestBody BusinessBill businessBill);

  /**
   * 修改业务单表
   * @param businessBill 业务单表
   * @return R
   */
  @PostMapping("/businessBill/update")
  public R updateById(@RequestBody BusinessBill businessBill);

  /**
   * 通过id删除业务单表
   * @param  id
   * @return R
   */
  @DeleteMapping("/businessBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}