package com.xforceplus.jcsmjt.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 合同单据表
 * </p>
 *
 * @author ultraman
 * @since 2021-12-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ContractBill implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 合同单号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 合同类型
   */
  @TableField("contractType")
  private String contractType;

  /**
   * 系统来源
   */
  @TableField("systemOrig")
  private String systemOrig;

  /**
   * 纸质合同编号
   */
  @TableField("paperContractNo")
  private String paperContractNo;

  /**
   * 合同名称
   */
  @TableField("contractName")
  private String contractName;

  /**
   * 销方编码
   */
  @TableField("sellerNo")
  private String sellerNo;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销方税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 购方编码
   */
  @TableField("purchaserNo")
  private String purchaserNo;

  /**
   * 购方名称
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 购方税号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 最终估价
   */
  @TableField("finalEvaluation")
  private String finalEvaluation;

  /**
   * 项目名称
   */
  @TableField("projectName")
  private String projectName;

  /**
   * 项目地址
   */
  @TableField("projectAddress")
  private String projectAddress;

  /**
   * 已付金额
   */
  @TableField("paidAmount")
  private String paidAmount;

  /**
   * 审核人
   */
  @TableField("reviewUserName")
  private String reviewUserName;

  /**
   * 审核日期
   */
  @TableField("reviewTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reviewTime;

  /**
   * 合同状态
   */
  private String status;

  /**
   * 已开金额
   */
  @TableField("openedAmount")
  private String openedAmount;

  /**
   * 待开金额
   */
  @TableField("beOpenedAmount")
  private String beOpenedAmount;

  /**
   * 剩余开票金额
   */
  @TableField("surplusInvoiceAmount")
  private String surplusInvoiceAmount;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 地块
   */
  private String massif;

  /**
   * 分期
   */
  @TableField("byStages")
  private String byStages;

  /**
   * 供应链融资
   */
  @TableField("supplyChainAmount")
  private String supplyChainAmount;

  /**
   * 币种
   */
  private String currency;

  /**
   * 汇率
   */
  @TableField("exchangeRate")
  private String exchangeRate;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("contractType", contractType);
      map.put("systemOrig", systemOrig);
      map.put("paperContractNo", paperContractNo);
      map.put("contractName", contractName);
      map.put("sellerNo", sellerNo);
      map.put("sellerName", sellerName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("purchaserNo", purchaserNo);
      map.put("purchaserName", purchaserName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("finalEvaluation", finalEvaluation);
      map.put("projectName", projectName);
      map.put("projectAddress", projectAddress);
      map.put("paidAmount", paidAmount);
      map.put("reviewUserName", reviewUserName);
      map.put("reviewTime", BocpGenUtils.toTimestamp(reviewTime));
      map.put("status", status);
      map.put("openedAmount", openedAmount);
      map.put("beOpenedAmount", beOpenedAmount);
      map.put("surplusInvoiceAmount", surplusInvoiceAmount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("massif", massif);
      map.put("byStages", byStages);
      map.put("supplyChainAmount", supplyChainAmount);
      map.put("currency", currency);
      map.put("exchangeRate", exchangeRate);
      return map;
  }

  public static ContractBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ContractBill entity = new ContractBill();
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractType")) {
      Object obj = map.get("contractType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemOrig")) {
      Object obj = map.get("systemOrig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperContractNo")) {
      Object obj = map.get("paperContractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractName")) {
      Object obj = map.get("contractName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("finalEvaluation")) {
      Object obj = map.get("finalEvaluation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFinalEvaluation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectAddress")) {
      Object obj = map.get("projectAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paidAmount")) {
      Object obj = map.get("paidAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaidAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reviewUserName")) {
      Object obj = map.get("reviewUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReviewUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reviewTime")) {
      Object obj = map.get("reviewTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReviewTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReviewTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReviewTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReviewTime(null);
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("openedAmount")) {
      Object obj = map.get("openedAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOpenedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("beOpenedAmount")) {
      Object obj = map.get("beOpenedAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBeOpenedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("surplusInvoiceAmount")) {
      Object obj = map.get("surplusInvoiceAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSurplusInvoiceAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("massif")) {
      Object obj = map.get("massif");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMassif((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("byStages")) {
      Object obj = map.get("byStages");
      if(obj != null) {
        if(obj instanceof String){
          entity.setByStages((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplyChainAmount")) {
      Object obj = map.get("supplyChainAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplyChainAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exchangeRate")) {
      Object obj = map.get("exchangeRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExchangeRate((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
