package com.xforceplus.jcsmjt.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcsmjt.entity.BusinessBill;
import com.xforceplus.jcsmjt.service.IBusinessBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 结算单表前端控制器
 *
 * @author ultraman
 * @date 2021-12-21
 */
@RestController
public class BusinessBillController {

  @Autowired
  private IBusinessBillService businessBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param businessBill 结算单表
   * @return
   */
  @GetMapping("/businessbills" )
  public XfR getBusinessBills(XfPage page, BusinessBill businessBill) {
    return XfR.ok(businessBillServiceImpl.page(page, Wrappers.query(businessBill)));
  }

  /**
   * 通过id查询结算单表
   * @param  id
   * @return XfR
   */
  @GetMapping("/businessbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(businessBillServiceImpl.getById(id));
  }

  /**
   * 新增结算单表
   * @param businessBill 结算单表
   * @return XfR
   */
  @PostMapping("/businessbills")
  public XfR save(@RequestBody BusinessBill businessBill) {
     return XfR.ok(businessBillServiceImpl.save(businessBill));
  }

  /**
   * 修改-传入修改后的全部数据结算单表
   * @param businessBill 结算单表
   * @return XfR
   */
  @PutMapping("/businessbills/{id}")
  public XfR putUpdate(@RequestBody BusinessBill businessBill,@PathVariable Long id) {
      businessBill.setId(id);
      return XfR.ok(businessBillServiceImpl.updateById(businessBill));
  }

  /**
   * 修改-传入修改的数据结算单表
   * @param businessBill 结算单表
   * @return XfR
   */
  @PatchMapping("/businessbills/{id}")
  public XfR patchUpdate(@RequestBody BusinessBill businessBill,@PathVariable Long id) {
      BusinessBill upbusinessBill = businessBillServiceImpl.getById(id);
      if(upbusinessBill != null){
        upbusinessBill = ObjectCopyUtils.copyProperties(businessBill,upbusinessBill,true);
      }
      return XfR.ok(businessBillServiceImpl.updateById(upbusinessBill));
  }

  /**
   * 通过id删除结算单表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/businessbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(businessBillServiceImpl.removeById(id));
  }

  @PostMapping("/businessbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "business_bill");
     params.put("request", condition);

     return XfR.ok(businessBillServiceImpl.querys(params));
  }

}
