package com.xforceplus.jcsmjt.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcsmjt.entity.ContractBill;
import com.xforceplus.jcsmjt.service.IContractBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 合同单据表前端控制器
 *
 * @author ultraman
 * @date 2021-12-21
 */
@RestController
public class ContractBillController {

  @Autowired
  private IContractBillService contractBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param contractBill 合同单据表
   * @return
   */
  @GetMapping("/contractbills" )
  public XfR getContractBills(XfPage page, ContractBill contractBill) {
    return XfR.ok(contractBillServiceImpl.page(page, Wrappers.query(contractBill)));
  }

  /**
   * 通过id查询合同单据表
   * @param  id
   * @return XfR
   */
  @GetMapping("/contractbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(contractBillServiceImpl.getById(id));
  }

  /**
   * 新增合同单据表
   * @param contractBill 合同单据表
   * @return XfR
   */
  @PostMapping("/contractbills")
  public XfR save(@RequestBody ContractBill contractBill) {
     return XfR.ok(contractBillServiceImpl.save(contractBill));
  }

  /**
   * 修改-传入修改后的全部数据合同单据表
   * @param contractBill 合同单据表
   * @return XfR
   */
  @PutMapping("/contractbills/{id}")
  public XfR putUpdate(@RequestBody ContractBill contractBill,@PathVariable Long id) {
      contractBill.setId(id);
      return XfR.ok(contractBillServiceImpl.updateById(contractBill));
  }

  /**
   * 修改-传入修改的数据合同单据表
   * @param contractBill 合同单据表
   * @return XfR
   */
  @PatchMapping("/contractbills/{id}")
  public XfR patchUpdate(@RequestBody ContractBill contractBill,@PathVariable Long id) {
      ContractBill upcontractBill = contractBillServiceImpl.getById(id);
      if(upcontractBill != null){
        upcontractBill = ObjectCopyUtils.copyProperties(contractBill,upcontractBill,true);
      }
      return XfR.ok(contractBillServiceImpl.updateById(upcontractBill));
  }

  /**
   * 通过id删除合同单据表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/contractbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(contractBillServiceImpl.removeById(id));
  }

  @PostMapping("/contractbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "contract_bill");
     params.put("request", condition);

     return XfR.ok(contractBillServiceImpl.querys(params));
  }

}
