package com.xforceplus.jcsmjt.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcsmjt.entity.ContractTaxRate;
import com.xforceplus.jcsmjt.service.IContractTaxRateService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 合同税率表前端控制器
 *
 * @author ultraman
 * @date 2021-12-21
 */
@RestController
public class ContractTaxRateController {

  @Autowired
  private IContractTaxRateService contractTaxRateServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param contractTaxRate 合同税率表
   * @return
   */
  @GetMapping("/contracttaxrates" )
  public XfR getContractTaxRates(XfPage page, ContractTaxRate contractTaxRate) {
    return XfR.ok(contractTaxRateServiceImpl.page(page, Wrappers.query(contractTaxRate)));
  }

  /**
   * 通过id查询合同税率表
   * @param  id
   * @return XfR
   */
  @GetMapping("/contracttaxrates/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(contractTaxRateServiceImpl.getById(id));
  }

  /**
   * 新增合同税率表
   * @param contractTaxRate 合同税率表
   * @return XfR
   */
  @PostMapping("/contracttaxrates")
  public XfR save(@RequestBody ContractTaxRate contractTaxRate) {
     return XfR.ok(contractTaxRateServiceImpl.save(contractTaxRate));
  }

  /**
   * 修改-传入修改后的全部数据合同税率表
   * @param contractTaxRate 合同税率表
   * @return XfR
   */
  @PutMapping("/contracttaxrates/{id}")
  public XfR putUpdate(@RequestBody ContractTaxRate contractTaxRate,@PathVariable Long id) {
      contractTaxRate.setId(id);
      return XfR.ok(contractTaxRateServiceImpl.updateById(contractTaxRate));
  }

  /**
   * 修改-传入修改的数据合同税率表
   * @param contractTaxRate 合同税率表
   * @return XfR
   */
  @PatchMapping("/contracttaxrates/{id}")
  public XfR patchUpdate(@RequestBody ContractTaxRate contractTaxRate,@PathVariable Long id) {
      ContractTaxRate upcontractTaxRate = contractTaxRateServiceImpl.getById(id);
      if(upcontractTaxRate != null){
        upcontractTaxRate = ObjectCopyUtils.copyProperties(contractTaxRate,upcontractTaxRate,true);
      }
      return XfR.ok(contractTaxRateServiceImpl.updateById(upcontractTaxRate));
  }

  /**
   * 通过id删除合同税率表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/contracttaxrates/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(contractTaxRateServiceImpl.removeById(id));
  }

  @PostMapping("/contracttaxrates/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "contract_tax_rate");
     params.put("request", condition);

     return XfR.ok(contractTaxRateServiceImpl.querys(params));
  }

}
