package com.xforceplus.jcsongxia.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2025-10-24
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcsongxia.entity.Order;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-songxia")
public interface OrderFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/order/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param order ${table.comment}
   * @return R
   */
  @PostMapping("/order/add")
  public R save(@RequestBody Order order);

  /**
   * 修改${table.comment}
   * @param order ${table.comment}
   * @return R
   */
  @PostMapping("/order/update")
  public R updateById(@RequestBody Order order);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/order/del/{id}" )
  public R removeById(@PathVariable Long id);

}