package com.xforceplus.jcsunart.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2022-07-26
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcsunart.entity.InvoiceDto;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-sunart")
public interface InvoiceDtoFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceDto/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param invoiceDto ${table.comment}
   * @return R
   */
  @PostMapping("/invoiceDto/add")
  public R save(@RequestBody InvoiceDto invoiceDto);

  /**
   * 修改${table.comment}
   * @param invoiceDto ${table.comment}
   * @return R
   */
  @PostMapping("/invoiceDto/update")
  public R updateById(@RequestBody InvoiceDto invoiceDto);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceDto/del/{id}" )
  public R removeById(@PathVariable Long id);

}