package com.xforceplus.jcsunart.controller;


/**
 * 发票签收推送记录表feign客户端
 *
 * @author ultraman
 * @date 2022-07-26
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcsunart.entity.InvoiceReceiptRecord;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-sunart")
public interface InvoiceReceiptRecordFeignApi {

  /**
   * 通过id查询发票签收推送记录表
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceReceiptRecord/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票签收推送记录表
   * @param invoiceReceiptRecord 发票签收推送记录表
   * @return R
   */
  @PostMapping("/invoiceReceiptRecord/add")
  public R save(@RequestBody InvoiceReceiptRecord invoiceReceiptRecord);

  /**
   * 修改发票签收推送记录表
   * @param invoiceReceiptRecord 发票签收推送记录表
   * @return R
   */
  @PostMapping("/invoiceReceiptRecord/update")
  public R updateById(@RequestBody InvoiceReceiptRecord invoiceReceiptRecord);

  /**
   * 通过id删除发票签收推送记录表
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceReceiptRecord/del/{id}" )
  public R removeById(@PathVariable Long id);

}