package com.xforceplus.jcsunart.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 退票种类
 * </p>
 *
 * @author ultraman
 * @since 2022-01-26
 */
public enum FefundType {

    _1("1", "手工退票"),
    _2("2", "系统退票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FefundType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FefundType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
