package com.xforceplus.jcsunart.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcsunart.entity.InvoiceReceiptRecord;
import com.xforceplus.jcsunart.service.IInvoiceReceiptRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 发票签收推送记录表前端控制器
 *
 * @author ultraman
 * @date 2022-04-26
 */
@RestController
public class InvoiceReceiptRecordController {

  @Autowired
  private IInvoiceReceiptRecordService invoiceReceiptRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceReceiptRecord 发票签收推送记录表
   * @return
   */
  @GetMapping("/invoicereceiptrecords" )
  public XfR getInvoiceReceiptRecords(XfPage page, InvoiceReceiptRecord invoiceReceiptRecord) {
    return XfR.ok(invoiceReceiptRecordServiceImpl.page(page, Wrappers.query(invoiceReceiptRecord)));
  }

  /**
   * 通过id查询发票签收推送记录表
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicereceiptrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceReceiptRecordServiceImpl.getById(id));
  }

  /**
   * 新增发票签收推送记录表
   * @param invoiceReceiptRecord 发票签收推送记录表
   * @return XfR
   */
  @PostMapping("/invoicereceiptrecords")
  public XfR save(@RequestBody InvoiceReceiptRecord invoiceReceiptRecord) {
     return XfR.ok(invoiceReceiptRecordServiceImpl.save(invoiceReceiptRecord));
  }

  /**
   * 修改-传入修改后的全部数据发票签收推送记录表
   * @param invoiceReceiptRecord 发票签收推送记录表
   * @return XfR
   */
  @PutMapping("/invoicereceiptrecords/{id}")
  public XfR putUpdate(@RequestBody InvoiceReceiptRecord invoiceReceiptRecord,@PathVariable Long id) {
      invoiceReceiptRecord.setId(id);
      return XfR.ok(invoiceReceiptRecordServiceImpl.updateById(invoiceReceiptRecord));
  }

  /**
   * 修改-传入修改的数据发票签收推送记录表
   * @param invoiceReceiptRecord 发票签收推送记录表
   * @return XfR
   */
  @PatchMapping("/invoicereceiptrecords/{id}")
  public XfR patchUpdate(@RequestBody InvoiceReceiptRecord invoiceReceiptRecord,@PathVariable Long id) {
      InvoiceReceiptRecord upinvoiceReceiptRecord = invoiceReceiptRecordServiceImpl.getById(id);
      if(upinvoiceReceiptRecord != null){
        upinvoiceReceiptRecord = ObjectCopyUtils.copyProperties(invoiceReceiptRecord,upinvoiceReceiptRecord,true);
      }
      return XfR.ok(invoiceReceiptRecordServiceImpl.updateById(upinvoiceReceiptRecord));
  }

  /**
   * 通过id删除发票签收推送记录表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicereceiptrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceReceiptRecordServiceImpl.removeById(id));
  }

  @PostMapping("/invoicereceiptrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_receipt_record");
     params.put("request", condition);

     return XfR.ok(invoiceReceiptRecordServiceImpl.querys(params));
  }

}
