package com.xforceplus.jcsunart.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcsunart.entity.InvoiceRefundRecord;
import com.xforceplus.jcsunart.service.IInvoiceRefundRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 发票退票推送记录前端控制器
 *
 * @author ultraman
 * @date 2022-04-26
 */
@RestController
public class InvoiceRefundRecordController {

  @Autowired
  private IInvoiceRefundRecordService invoiceRefundRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceRefundRecord 发票退票推送记录
   * @return
   */
  @GetMapping("/invoicerefundrecords" )
  public XfR getInvoiceRefundRecords(XfPage page, InvoiceRefundRecord invoiceRefundRecord) {
    return XfR.ok(invoiceRefundRecordServiceImpl.page(page, Wrappers.query(invoiceRefundRecord)));
  }

  /**
   * 通过id查询发票退票推送记录
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicerefundrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceRefundRecordServiceImpl.getById(id));
  }

  /**
   * 新增发票退票推送记录
   * @param invoiceRefundRecord 发票退票推送记录
   * @return XfR
   */
  @PostMapping("/invoicerefundrecords")
  public XfR save(@RequestBody InvoiceRefundRecord invoiceRefundRecord) {
     return XfR.ok(invoiceRefundRecordServiceImpl.save(invoiceRefundRecord));
  }

  /**
   * 修改-传入修改后的全部数据发票退票推送记录
   * @param invoiceRefundRecord 发票退票推送记录
   * @return XfR
   */
  @PutMapping("/invoicerefundrecords/{id}")
  public XfR putUpdate(@RequestBody InvoiceRefundRecord invoiceRefundRecord,@PathVariable Long id) {
      invoiceRefundRecord.setId(id);
      return XfR.ok(invoiceRefundRecordServiceImpl.updateById(invoiceRefundRecord));
  }

  /**
   * 修改-传入修改的数据发票退票推送记录
   * @param invoiceRefundRecord 发票退票推送记录
   * @return XfR
   */
  @PatchMapping("/invoicerefundrecords/{id}")
  public XfR patchUpdate(@RequestBody InvoiceRefundRecord invoiceRefundRecord,@PathVariable Long id) {
      InvoiceRefundRecord upinvoiceRefundRecord = invoiceRefundRecordServiceImpl.getById(id);
      if(upinvoiceRefundRecord != null){
        upinvoiceRefundRecord = ObjectCopyUtils.copyProperties(invoiceRefundRecord,upinvoiceRefundRecord,true);
      }
      return XfR.ok(invoiceRefundRecordServiceImpl.updateById(upinvoiceRefundRecord));
  }

  /**
   * 通过id删除发票退票推送记录
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicerefundrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceRefundRecordServiceImpl.removeById(id));
  }

  @PostMapping("/invoicerefundrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_refund_record");
     params.put("request", condition);

     return XfR.ok(invoiceRefundRecordServiceImpl.querys(params));
  }

}
