package com.xforceplus.jcsunart.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcsunart.entity.InvoiceRefundReport;
import com.xforceplus.jcsunart.service.IInvoiceRefundReportService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 发票签收报表前端控制器
 *
 * @author ultraman
 * @date 2022-04-26
 */
@RestController
public class InvoiceRefundReportController {

  @Autowired
  private IInvoiceRefundReportService invoiceRefundReportServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceRefundReport 发票签收报表
   * @return
   */
  @GetMapping("/invoicerefundreports" )
  public XfR getInvoiceRefundReports(XfPage page, InvoiceRefundReport invoiceRefundReport) {
    return XfR.ok(invoiceRefundReportServiceImpl.page(page, Wrappers.query(invoiceRefundReport)));
  }

  /**
   * 通过id查询发票签收报表
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicerefundreports/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceRefundReportServiceImpl.getById(id));
  }

  /**
   * 新增发票签收报表
   * @param invoiceRefundReport 发票签收报表
   * @return XfR
   */
  @PostMapping("/invoicerefundreports")
  public XfR save(@RequestBody InvoiceRefundReport invoiceRefundReport) {
     return XfR.ok(invoiceRefundReportServiceImpl.save(invoiceRefundReport));
  }

  /**
   * 修改-传入修改后的全部数据发票签收报表
   * @param invoiceRefundReport 发票签收报表
   * @return XfR
   */
  @PutMapping("/invoicerefundreports/{id}")
  public XfR putUpdate(@RequestBody InvoiceRefundReport invoiceRefundReport,@PathVariable Long id) {
      invoiceRefundReport.setId(id);
      return XfR.ok(invoiceRefundReportServiceImpl.updateById(invoiceRefundReport));
  }

  /**
   * 修改-传入修改的数据发票签收报表
   * @param invoiceRefundReport 发票签收报表
   * @return XfR
   */
  @PatchMapping("/invoicerefundreports/{id}")
  public XfR patchUpdate(@RequestBody InvoiceRefundReport invoiceRefundReport,@PathVariable Long id) {
      InvoiceRefundReport upinvoiceRefundReport = invoiceRefundReportServiceImpl.getById(id);
      if(upinvoiceRefundReport != null){
        upinvoiceRefundReport = ObjectCopyUtils.copyProperties(invoiceRefundReport,upinvoiceRefundReport,true);
      }
      return XfR.ok(invoiceRefundReportServiceImpl.updateById(upinvoiceRefundReport));
  }

  /**
   * 通过id删除发票签收报表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicerefundreports/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceRefundReportServiceImpl.removeById(id));
  }

  @PostMapping("/invoicerefundreports/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_refund_report");
     params.put("request", condition);

     return XfR.ok(invoiceRefundReportServiceImpl.querys(params));
  }

}
