package com.xforceplus.jctke.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2022-04-24
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.Enclosure;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface EnclosureFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/enclosure/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param enclosure ${table.comment}
   * @return R
   */
  @PostMapping("/enclosure/add")
  public R save(@RequestBody Enclosure enclosure);

  /**
   * 修改${table.comment}
   * @param enclosure ${table.comment}
   * @return R
   */
  @PostMapping("/enclosure/update")
  public R updateById(@RequestBody Enclosure enclosure);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/enclosure/del/{id}" )
  public R removeById(@PathVariable Long id);

}