package com.xforceplus.jctke.controller;


/**
 * 采购订单主信息feign客户端
 *
 * @author ultraman
 * @date 2022-04-24
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.PurchaseOrder;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface PurchaseOrderFeignApi {

  /**
   * 通过id查询采购订单主信息
   * @param  id
   * @return R
   */
  @GetMapping("/purchaseOrder/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增采购订单主信息
   * @param purchaseOrder 采购订单主信息
   * @return R
   */
  @PostMapping("/purchaseOrder/add")
  public R save(@RequestBody PurchaseOrder purchaseOrder);

  /**
   * 修改采购订单主信息
   * @param purchaseOrder 采购订单主信息
   * @return R
   */
  @PostMapping("/purchaseOrder/update")
  public R updateById(@RequestBody PurchaseOrder purchaseOrder);

  /**
   * 通过id删除采购订单主信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/purchaseOrder/del/{id}" )
  public R removeById(@PathVariable Long id);

}