package com.xforceplus.jctke.controller;


/**
 * 发票登记表feign客户端
 *
 * @author ultraman
 * @date 2022-03-24
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.Invoice;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface InvoiceFeignApi {

  /**
   * 通过id查询发票登记表
   * @param  id
   * @return R
   */
  @GetMapping("/invoice/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票登记表
   * @param invoice 发票登记表
   * @return R
   */
  @PostMapping("/invoice/add")
  public R save(@RequestBody Invoice invoice);

  /**
   * 修改发票登记表
   * @param invoice 发票登记表
   * @return R
   */
  @PostMapping("/invoice/update")
  public R updateById(@RequestBody Invoice invoice);

  /**
   * 通过id删除发票登记表
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoice/del/{id}" )
  public R removeById(@PathVariable Long id);

}