package com.xforceplus.jctke.controller;


/**
 *  po预付单feign客户端
 *
 * @author ultraman
 * @date 2022-05-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.PoImprest;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface PoImprestFeignApi {

  /**
   * 通过id查询 po预付单
   * @param  id
   * @return R
   */
  @GetMapping("/poImprest/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增 po预付单
   * @param poImprest  po预付单
   * @return R
   */
  @PostMapping("/poImprest/add")
  public R save(@RequestBody PoImprest poImprest);

  /**
   * 修改 po预付单
   * @param poImprest  po预付单
   * @return R
   */
  @PostMapping("/poImprest/update")
  public R updateById(@RequestBody PoImprest poImprest);

  /**
   * 通过id删除 po预付单
   * @param  id
   * @return R
   */
  @DeleteMapping("/poImprest/del/{id}" )
  public R removeById(@PathVariable Long id);

}