package com.xforceplus.jctke.controller;


/**
 * 采购单原始数据feign客户端
 *
 * @author ultraman
 * @date 2022-05-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.PurchaseOrderInit;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface PurchaseOrderInitFeignApi {

  /**
   * 通过id查询采购单原始数据
   * @param  id
   * @return R
   */
  @GetMapping("/purchaseOrderInit/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增采购单原始数据
   * @param purchaseOrderInit 采购单原始数据
   * @return R
   */
  @PostMapping("/purchaseOrderInit/add")
  public R save(@RequestBody PurchaseOrderInit purchaseOrderInit);

  /**
   * 修改采购单原始数据
   * @param purchaseOrderInit 采购单原始数据
   * @return R
   */
  @PostMapping("/purchaseOrderInit/update")
  public R updateById(@RequestBody PurchaseOrderInit purchaseOrderInit);

  /**
   * 通过id删除采购单原始数据
   * @param  id
   * @return R
   */
  @DeleteMapping("/purchaseOrderInit/del/{id}" )
  public R removeById(@PathVariable Long id);

}