package com.xforceplus.jctke.controller;


/**
 * AgentFeeReport 原始数据错误履历feign客户端
 *
 * @author ultraman
 * @date 2022-05-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.AgentFeeReportInitFailedHistory;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface AgentFeeReportInitFailedHistoryFeignApi {

  /**
   * 通过id查询AgentFeeReport 原始数据错误履历
   * @param  id
   * @return R
   */
  @GetMapping("/agentFeeReportInitFailedHistory/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增AgentFeeReport 原始数据错误履历
   * @param agentFeeReportInitFailedHistory AgentFeeReport 原始数据错误履历
   * @return R
   */
  @PostMapping("/agentFeeReportInitFailedHistory/add")
  public R save(@RequestBody AgentFeeReportInitFailedHistory agentFeeReportInitFailedHistory);

  /**
   * 修改AgentFeeReport 原始数据错误履历
   * @param agentFeeReportInitFailedHistory AgentFeeReport 原始数据错误履历
   * @return R
   */
  @PostMapping("/agentFeeReportInitFailedHistory/update")
  public R updateById(@RequestBody AgentFeeReportInitFailedHistory agentFeeReportInitFailedHistory);

  /**
   * 通过id删除AgentFeeReport 原始数据错误履历
   * @param  id
   * @return R
   */
  @DeleteMapping("/agentFeeReportInitFailedHistory/del/{id}" )
  public R removeById(@PathVariable Long id);

}