package com.xforceplus.jctke.controller;


/**
 * 供应商原始数据feign客户端
 *
 * @author ultraman
 * @date 2022-05-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.SellerInit;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface SellerInitFeignApi {

  /**
   * 通过id查询供应商原始数据
   * @param  id
   * @return R
   */
  @GetMapping("/sellerInit/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增供应商原始数据
   * @param sellerInit 供应商原始数据
   * @return R
   */
  @PostMapping("/sellerInit/add")
  public R save(@RequestBody SellerInit sellerInit);

  /**
   * 修改供应商原始数据
   * @param sellerInit 供应商原始数据
   * @return R
   */
  @PostMapping("/sellerInit/update")
  public R updateById(@RequestBody SellerInit sellerInit);

  /**
   * 通过id删除供应商原始数据
   * @param  id
   * @return R
   */
  @DeleteMapping("/sellerInit/del/{id}" )
  public R removeById(@PathVariable Long id);

}