package com.xforceplus.jctke.controller;


/**
 * WBS原始数据feign客户端
 *
 * @author ultraman
 * @date 2022-04-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.WbsInit;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface WbsInitFeignApi {

  /**
   * 通过id查询WBS原始数据
   * @param  id
   * @return R
   */
  @GetMapping("/wbsInit/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增WBS原始数据
   * @param wbsInit WBS原始数据
   * @return R
   */
  @PostMapping("/wbsInit/add")
  public R save(@RequestBody WbsInit wbsInit);

  /**
   * 修改WBS原始数据
   * @param wbsInit WBS原始数据
   * @return R
   */
  @PostMapping("/wbsInit/update")
  public R updateById(@RequestBody WbsInit wbsInit);

  /**
   * 通过id删除WBS原始数据
   * @param  id
   * @return R
   */
  @DeleteMapping("/wbsInit/del/{id}" )
  public R removeById(@PathVariable Long id);

}