package com.xforceplus.jctke.controller;


/**
 * 线上审批规则feign客户端
 *
 * @author ultraman
 * @date 2022-06-07
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jctke.entity.ApprovalRules;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-tke")
public interface ApprovalRulesFeignApi {

  /**
   * 通过id查询线上审批规则
   * @param  id
   * @return R
   */
  @GetMapping("/approvalRules/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增线上审批规则
   * @param approvalRules 线上审批规则
   * @return R
   */
  @PostMapping("/approvalRules/add")
  public R save(@RequestBody ApprovalRules approvalRules);

  /**
   * 修改线上审批规则
   * @param approvalRules 线上审批规则
   * @return R
   */
  @PostMapping("/approvalRules/update")
  public R updateById(@RequestBody ApprovalRules approvalRules);

  /**
   * 通过id删除线上审批规则
   * @param  id
   * @return R
   */
  @DeleteMapping("/approvalRules/del/{id}" )
  public R removeById(@PathVariable Long id);

}